// EngineDLL.h
//
// Copyright 1998-2000 Zillions Development
//
// Shared DLL plug-in for DLL engine and Zillions

#include "windows.h"

typedef enum {
    kKEEPSEARCHING = 0,
    kSTOPSOON = 1,
    kSTOPNOW = 2
} Search_Status;

typedef enum {
    DLL_OK = 0,
    DLL_OK_DONT_SEND_SETUP = 1, // only supported in 1.0.2 and higher!

    DLL_GENERIC_ERROR = -1,
    DLL_OUT_OF_MEMORY_ERROR = -2,
    DLL_UNKNOWN_VARIANT_ERROR = -3,
    DLL_UNKNOWN_PLAYER_ERROR = -4,
    DLL_UNKNOWN_PIECE_ERROR = -5,
    DLL_WRONG_SIDE_TO_MOVE_ERROR = -6,
    DLL_INVALID_POSITION_ERROR = -7,
    DLL_NO_MOVES = -8
} DLL_Result;

enum {
    UNKNOWN_SCORE = -2140000000L,
    LOSS_SCORE = -2130000000L,
    DRAW_SCORE = 0,
    WIN_SCORE = 2130000000L
};

// ***** REQUIRED ROUTINES

// DLL_Search
//
// The DLL should search from the current position. If it returns DLL_OK it should
// also return the best move found in str; however, it should not make the move
// internally. A separate call to MakeAMove() will follow to make the move the
// engine returns.
//
// -> lSearchTime: Target search time in milliseconds
// -> lDepthLimit: Maximum moves deep the engine should search
// -> lVariety: Variety setting for engine. 0 = no variety, 10 = most variety
// -> pSearchStatus: Pointer to variable where Zillions will report search status
// -> bestMove: Pointer to a string where engine can report the best move found so far
// -> currentMove: Pointer to a string where engine can report the move being searched
// -> plNodes: Pointer to a long where engine can report # of positions searched so far
// -> plScore: Pointer to a long where engine can report current best score in search
// -> plDepth: Pointer to a long where engine can report current search depth
//
// Returns DLL_OK or a negative error code 

typedef DLL_Result (FAR PASCAL *SEARCH)(long lSearchTime, long lDepthLimit, long lVariety,
    const Search_Status *pSearchStatus, LPSTR bestMove, LPSTR currentMove,
    long *plNodes, long *plScore, long *plDepth);


// DLL_MakeAMove
//
// The DLL should try to make the given move internally.
//
// -> move: notation for the move that the engine should make
//
// Returns DLL_OK or a negative error code 

typedef DLL_Result (FAR PASCAL *MAKEAMOVE)(LPCSTR move);


// DLL_StartNewGame
//
// The DLL should reset the board for a new game.
//
// -> variant: The variant to be played as it appears in the variant menu
//
// Returns DLL_OK, DLL_OK_DONT_SEND_SETUP, DLL_OUT_OF_MEMORY_ERROR, or
//   DLL_GENERIC_ERROR

typedef DLL_Result (FAR PASCAL *STARTNEWGAME)(LPCSTR variant);

// DLL_CleanUp
//
// The DLL should free memory and prepare to be unloaded.
//
// Returns DLL_OK, DLL_OUT_OF_MEMORY_ERROR, or DLL_GENERIC_ERROR

typedef DLL_Result (FAR PASCAL *CLEANUP)(void);


// ***** OPTIONAL ROUTINES

// DLL_IsGameOver
//
// This optional function is called by Zillions to see if a game is over.  If 
// not present, Zillions uses the goal in the ZRF to decide the winner.
//
// -> lResult: Pointer to the game result which the DLL should fill in when
//              called.  If the game is over the routine should fill in WIN_SCORE,
//              DRAW_SCORE, or LOSS_SCORE.  Otherwise the routine should fill in
//              UNKNOWN_SCORE.
// -> zcomment: Pointer to a 500-char string in Zillions which the DLL can optionally 
//              fill in, to make an announcement about why the game is over, such
//              as "Draw by third repetition".  The DLL should not modify this 
//              string if there is nothing to report.
//
// Returns DLL_OK or a negative error code 

typedef DLL_Result (FAR PASCAL *ISGAMEOVER)(long *lResult, LPSTR zcomment);


// DLL_GenerateMoves
//
// You can use GenerateMoves in your DLL to tell Zillions the legal moves for 
// any position in the game.
//  
// -> moveBuffer: Pointer to a 1024-char sting which the DLL should fill in when
//              called.  Initial call should be with moveBuffer set to "".  Each call 
//              to GenerateMoves should fill in the next available move from the 
//              current position, with a final "" when no more moves are available.
//              All moves must be in valid Zillions move string format.
//
// Returns DLL_OK or a negative error code 

typedef DLL_Result (FAR PASCAL *GENERATEMOVES)(LPCSTR moveBuffer);
